---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-OPFS 並行性テスト画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/tests/opfs/concurrency/index.html` - メインHTMLファイル
- E-02: `ext/wasm/tests/opfs/concurrency/test.js` - テスト制御スクリプト
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.15）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数Workerで並行テスト | E-01 行20-21, E-02 行150-157 | ○ |
| C-02 | OPFSの並行処理は課題(pain point) | E-01 行21 "Disclaimer: concurrency in OPFS is currently a pain point!" | ○ |
| C-03 | workers=NでWorker数指定 | E-02 行57-59 | ○ |
| C-04 | interval=Nでインターバル指定 | E-02 行63-65 | ○ |
| C-05 | iterations=Nでイテレーション回数指定 | E-02 行66-68 | ○ |
| C-06 | verbose=1-3で詳細ログ指定 | E-01 行28, E-02 行60-62 | ○ |
| C-07 | unlock-asap=0-1でモード切替 | E-01 行29, E-02 行69-71 | ○ |
| C-08 | no-unlinkでDB削除無効化 | E-02 行72 | ○ |
| C-09 | デフォルトworkers=3 | E-02 行58 | ○ |
| C-10 | デフォルトinterval=1000 | E-02 行64 | ○ |
| C-11 | デフォルトiterations=10 | E-02 行67 | ○ |
| C-12 | 全Worker loaded後にrun送信 | E-02 行94-97 | ○ |
| C-13 | checkFinishedで完了判定 | E-02 行78-87 | ○ |
| C-14 | テストリンクを動的生成 | E-02 行126-139 | ○ |
| C-15 | 機能No.1 SQLiteライブラリ初期化が関連 | E-04 行61 | ○ |
| C-16 | 機能No.43 OS抽象化層（VFS）が関連 | E-04 行62 | ○ |
| C-17 | 機能No.42 ミューテックスが関連 | E-04 行63 | ○ |
| C-18 | WasmMemory警告メッセージ | E-01 行32-36 | ○ |
| C-19 | workers.postで全Workerに送信 | E-02 行74-76 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各URLパラメータが実際に動作するか確認
- [ ] 高負荷時（workers=10, iterations=100等）の安定性確認
- [ ] unlock-asapモードの効果が観測できるか確認
